<?php
    $referralContent = getContent('referral.content', true);
?>
<?php $__env->startSection('content'); ?>
<section class="dashboard-section body-collapse">
    <div class="overlay pt-120">
        <div class="container-fruid">
            <div class="row justify-content-center">
                <?php if(gs('referral_system')): ?>
                    <div class="col-12">
                        <div class="card custom--card mb-5">
                            <div class="card-header">
                                <h5 class="card-title"><?php echo app('translator')->get('Refer & Enjoy the Bonus'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group mb-3">
                                    <div class="input-group">
                                        <input type="text" name="key"
                                            value="<?php echo e(route('home')); ?>?reference=<?php echo e($user->username); ?>"
                                            class="form-control form--control referralURL" readonly>
                                        <button type="button" class="input-group-text copytext" id="copyBoard">
                                            <i class="fa fa-copy"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-md-12">
                    <div class="card custom--card">
                        <div class="card-header">
                            <h5 class="card-title">
                                <?php echo e(__($pageTitle)); ?>

                            </h5>
                        </div>
                        <div class="card-body">
                            <form class="register" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="form-group col-sm-12 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Profile Image'); ?>
                                        </label>
                                
                                        <input type="file"
                                               name="image"
                                               class="form-control form--control"
                                               accept="image/*">
                                
                                        
                                        <?php if($user->image): ?>
                                            <div class="mt-2">
                                                <img src="<?php echo e(asset('assets/images/user/profile/'.$user->image)); ?>"
                                                     alt="Profile Image"
                                                     class="img-fluid rounded"
                                                     style="max-width: 120px;">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-sm-6 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('First Name'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="firstname"
                                            value="<?php echo e($user->firstname); ?>" required>
                                    </div>
                                    <div class="form-group col-sm-6 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Last Name'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="lastname"
                                            value="<?php echo e($user->lastname); ?>" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-sm-6 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('E-mail Address'); ?>
                                        </label>
                                        <input class="form-control form--control" value="<?php echo e($user->email); ?>" readonly>
                                    </div>
                                    <div class="form-group col-sm-6 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Mobile Number'); ?>
                                        </label>
                                        <input class="form-control form--control" value="<?php echo e($user->mobile); ?>" readonly>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-12 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Address'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="address"
                                            value="<?php echo e(@$user->address); ?>">
                                    </div>
                                    <div class="form-group col-sm-6 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('State'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="state"
                                            value="<?php echo e(@$user->state); ?>">
                                    </div>
                                    <div class="form-group col-sm-6 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Zip Code'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="zip"
                                            value="<?php echo e(@$user->zip); ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-sm-4 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('City'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="city"
                                            value="<?php echo e(@$user->city); ?>">
                                    </div>
                                    <div class="form-group col-sm-4 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Country'); ?>
                                        </label>
                                        <input class="form-control form--control" value="<?php echo e(@$user->country_name); ?>"
                                            disabled>
                                    </div>
                                    <div class="form-group col-sm-4 mb-3">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Acount Type'); ?>
                                        </label>
                                        <?php if($user->type == Status::PERSONAL_USER): ?>
                                            <input class="form-control form--control" value="Personal" disabled>
                                        <?php else: ?>
                                            <input class="form-control form--control" value="Business" disabled>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if($user->type == Status::BUSINESS_USER): ?>
                                    <div class="row justify-content-center">
                                        <div class="col-lg-12">
                                            <?php if($user->business_profile_data): ?>
                                                <ul class="list-group ">
                                                    <?php $__currentLoopData = $user->business_profile_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!$val->value) continue; ?>
                                                        <li
                                                            class="list-group-item list-group-flush d-flex justify-content-between align-items-center py-3">
                                                            <?php echo e(__($val->name)); ?>

                                                            <span>
                                                                <?php if($val->type == 'checkbox'): ?>
                                                                    <?php echo e(implode(',', $val->value)); ?>

                                                                <?php elseif($val->type == 'file'): ?>
                                                                    <?php if($val->value): ?>
                                                                        <a href="<?php echo e(route('admin.download.attachment', encrypt(getFilePath('verify') . '/' . $val->value))); ?>"
                                                                            class="me-3">
                                                                            <i class="fa fa-file"></i>
                                                                            <?php echo app('translator')->get('Attachment'); ?>
                                                                        </a>
                                                                    <?php else: ?>
                                                                        <?php echo app('translator')->get('No File'); ?>
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <p class="m-0"><?php echo e(__($val->value)); ?></p>
                                                                <?php endif; ?>
                                                            </span>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="form-group mt-3">
                                    <button type="submit" class="btn btn--base w-100 btn--xl">
                                        <?php echo app('translator')->get('Submit'); ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .copied::after {
            background-color: #<?php echo e(gs('base_color')); ?>;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('#copyBoard').on('click', function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/user/profile_setting.blade.php ENDPATH**/ ?>