<?php $__env->startSection('content'); ?>
    <?php
        if (old()) {
            $sendingAmount = old('sending_amount');
            $recipientAmount = old('recipient_amount');
            $deliveryMethodId = old('delivery_method');
            $sendingCountryId = old('sending_country');
            $recipientCountryId = old('recipient_country');
        }

        $user = auth()->user();
    ?>
<section class="dashboard-section body-collapse pay">
    <div class="overlay pt-120">
        <div class="container-fruid">
            <h4 class="text-center"><?php echo app('translator')->get('Send Money Form'); ?></h4>
            <form action="<?php echo e(route('user.send.money.save')); ?>" class="card-body container-fluid register disableSubmission" method="post">
                <?php echo csrf_field(); ?>
                <div class="row g-4">
                    <div class="col-lg-6 ">
                        <div class="card custom--card h-100">
                            <div class="card-header">
                                <h5 class="card-title text-center"><?php echo app('translator')->get('Sender Information'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="exchange-form">
                                    <div class="exchange-form__body p-0">
                                        <?php echo $__env->make($activeTemplate . 'partials.country_fields', [
                                            'class' => 'mb-3',
                                            'showLimit' => true,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <div class="conversion__rate mb-5">
                                            <div>1 <span class="sending-currency"></span> = </div>
                                            <div class="exchange-rate ms-1"></div>
                                            <div class="recipient-currency ms-1"></div>
                                        </div>
                                        <div class="select-wrapper">
                                            <div class="form-group mb-3">
                                                <label class="text--accent sm-text d-block fw-md mb-2"><?php echo app('translator')->get('Source of Funds'); ?></label>
                                                <select class="form-select form--select select2-basic" data-minimum-results-for-search="-1" name="source_of_funds" required>
                                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                                    <?php $__currentLoopData = $sources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if(old('source_of_funds') == $source->id): echo 'selected'; endif; ?> value="<?php echo e($source->id); ?>">
                                                            <?php echo e(__($source->name)); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label class="text--accent sm-text d-block fw-md mb-2"><?php echo app('translator')->get('Sending Purpose'); ?></label>
                                                <select class="form-select form--select select2-basic" data-minimum-results-for-search="-1" name="sending_purpose" required>
                                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                                    <?php $__currentLoopData = $purposes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purpose): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if(old('sending_purpose') == $purpose->id): echo 'selected'; endif; ?> value="<?php echo e($purpose->id); ?>">
                                                            <?php echo e(__($purpose->name)); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <h5 class=""><?php echo app('translator')->get('Payment Via'); ?></h5>
                                    <div class="d-flex flex-wrap gap-3">
                                        <label class="btn-selected__label flex-grow-1" data-value="1" for="walletBtn">
                                            <input class="btn-selected__input walletPayment" data-balance="<?php echo e(auth()->user()->balance); ?>" id="walletBtn" name="payment_type" required type="radio" value="1">
                                            <span class="btn-selected btn-selected--primary">
                                                <span class="btn-selected__icon">
                                                    <img alt="wallet image" class="img-fluid" src="<?php echo e(getImage($activeTemplateTrue . 'images/wallet-icon.png')); ?>">
                                                </span>
                                                <span class="btn-selected__text ">
                                                    <?php echo app('translator')->get('Refunded'); ?> <?php echo app('translator')->get('Wallet'); ?>
                                                </span>
                                            </span>
                                        </label>
                                        <label class="btn-selected__label flex-grow-1" data-value="2" for="directBtn">
                                            <input class="btn-selected__input directPayment" id="directBtn" name="payment_type" required type="radio" value="2">
                                            <div class="btn-selected btn-selected--secondary">
                                                <span class="btn-selected__icon">
                                                    <img alt="credit image" class="img-fluid" src="<?php echo e(getImage($activeTemplateTrue . 'images/credit-card-icon.png')); ?>">
                                                </span>
                                                <span class="btn-selected__text ">
                                                    <?php echo app('translator')->get('Direct Payment'); ?>
                                                </span>
                                            </div>
                                        </label>
                                    </div>
                                    <small class="text--danger insufficientBalanceError d-none">
                                        <?php echo app('translator')->get('You don\'t have sufficient balance. Your current balance is'); ?>
                                        <?php echo e(showAmount(auth()->user()->balance)); ?>

                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="card custom--card">
                            <div class="card-header">
                                <h5 class="card-title text-center"><?php echo app('translator')->get('Recipient Information'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="text--accent sm-text d-block fw-md mb-2">
                                        <?php echo app('translator')->get('Existing Recipient'); ?>
                                    </label>
                                    <select class="form-select form--select existing-recipient select2-basic" data-minimum-results-for-search="-1">
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = $recipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option data-recipient="<?php echo e($recipient); ?>"><?php echo e($recipient->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group mb-3">
                                    <label class="text--accent sm-text d-block fw-md mb-2" for="recipient_name">
                                        <?php echo app('translator')->get('Recipient Name'); ?>
                                    </label>
                                    <input class="form-control form--control recipient_name" id="recipient_name" name="recipient[name]" required type="text" value="<?php echo e(old('recipient')['name'] ?? null); ?>">
                                </div>
                                <div class="form-group mb-3">
                                    <label class="text--accent sm-text d-block fw-md mb-2" for="recipient_mobile">
                                        <?php echo app('translator')->get('Recipient Mobile No.'); ?>
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text recipient-dial-code"></span>
                                        <input class="form-control form--control checkRecipient" id="recipient_mobile" name="recipient[mobile]" required type="number" value="<?php echo e(old('recipient')['mobile'] ?? null); ?>">
                                    </div>
                                </div>
                                <div class="form-group mb-3">
                                    <label class="text--accent sm-text d-block fw-md mb-2" for="recipient_email">
                                        <?php echo app('translator')->get('Recipient Email'); ?>
                                    </label>
                                    <input class="form-control form--control checkRecipient" id="recipient_email" name="recipient[email]" required type="email" value="<?php echo e(old('recipient')['email'] ?? null); ?>">
                                </div>
                                <div class="form-group mb-3">
                                    <label class="text--accent sm-text d-block fw-md mb-2" for="recipient_address">
                                        <?php echo app('translator')->get('Recipient Address'); ?>
                                    </label>
                                    <input class="form-control form--control-textarea" id="recipient_address" name="recipient[address]" value="<?php echo e(old('recipient')['address'] ?? null); ?>" required>
                                </div>

                                <div class="form-group mb-3">
                                    <label class="text--accent sm-text d-block fw-md mb-2" for="deliveryMethod">
                                        <?php echo app('translator')->get('Delivery Methods'); ?>
                                    </label>
                                    <select class="form-select form--select select2-basic" data-minimum-results-for-search="-1" id="deliveryMethod" name="delivery_method" required>
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    </select>
                                </div>

                                <div class="mb-3 services-div d-none">
                                    <div class="form-group mb-3">
                                        <label class="text--accent sm-text d-block fw-md mb-2"><?php echo app('translator')->get('Service'); ?></label>
                                        <div class="form--select-light">
                                            <select class="form-select form--select select2-basic countryServices" data-minimum-results-for-search="-1" name="service">
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3 mt-4 d-none formData"></div>
                                <div class="mb-3 mt-4" id="saveRecipientContainer">
                                    <input type="checkbox" <?php if(old('save_recipient')): echo 'checked'; endif; ?> name="save_recipient" id="save_recipient">
                                    <label for="save_recipient"><?php echo app('translator')->get('Save Recipient'); ?></label>
                                </div>

                                <div class="mb-3 mt-4">
                                    <ul class="list list--column payment-table">
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <span class="d-block t-heading-font heading-clr sm-text">
                                                    <?php echo app('translator')->get('Sending Amount'); ?>
                                                </span>
                                                <h5 class="fw-md heading-clr t-heading-font sm-text m-0">
                                                    <span class="sending-amount-total"></span>
                                                    <span class="sending-currency"></span>
                                                </h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <span class="d-block sm-text">
                                                    <?php echo app('translator')->get('Total Charge'); ?>
                                                </span>
                                                <h5 class="fw-md heading-clr t-heading-font sm-text m-0">
                                                    <span class="charge-amount-text"></span>
                                                    <span class="sending-currency"></span>
                                                </h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <span class="d-block t-heading-font heading-clr sm-text">
                                                    <?php echo app('translator')->get('Final Amount'); ?>
                                                </span>
                                                <h5 class="sm-text m-0">
                                                    <span class="final-amount-text"></span>
                                                    <span class="sending-currency"></span>
                                                </h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center justify-content-between">
                                                <span class="d-block sm-text">
                                                    <?php echo app('translator')->get('Payable In '); ?><?php echo e(__(gs('cur_text'))); ?>

                                                </span>
                                                <h5 class="text--base sm-text m-0">
                                                    <span class="base-amount-text"></span>
                                                    <span><?php echo e(__(gs('cur_text'))); ?></span>
                                                </h5>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <button class="btn btn--base btn--xl w-100 formSubmitButton" type="submit">
                                    <?php echo app('translator')->get('Continue'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

    <div class="modal custom--modal fade" id="limitModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Send Money Limit'); ?></h5>
                    <button aria-label="Close" class="close btn btn--danger btn-sm close-button" data-bs-dismiss="modal" type="button">
                        <i aria-hidden="true" class="la la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list list--column payment-table" id="transfer-limit">
                        <li>
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="d-block t-heading-font heading-clr sm-text">
                                    <?php echo app('translator')->get('Per Transfer'); ?>
                                </span>
                                <h6 class="fw-md heading-clr t-heading-font sm-text m-0">
                                    <span class="send_money_limit">0</span>
                                    <span class="sending-currency"></span>
                                </h6>
                            </div>
                        </li>
                        <li>
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="d-block t-heading-font heading-clr sm-text">
                                    <?php echo app('translator')->get('Daily Limit'); ?>
                                </span>
                                <h5 class="sm-text m-0">
                                    <span class="daily_send_money_limit">0</span>
                                    <span class="sending-currency"></span>
                                </h5>
                            </div>
                        </li>
                        <li>
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="d-block t-heading-font heading-clr sm-text">
                                    <?php echo app('translator')->get('Available for Today'); ?>
                                </span>
                                <h5 class="sm-text m-0">
                                    <span class="today_limit">0</span>
                                    <span class="sending-currency"></span>
                                </h5>
                            </div>
                        </li>
                        <li>
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="d-block t-heading-font heading-clr sm-text">
                                    <?php echo app('translator')->get('Monthly Limit'); ?>
                                </span>
                                <h5 class="sm-text m-0">
                                    <span class="monthly_send_money_limit">0</span>
                                    <span class="sending-currency"></span>
                                </h5>
                            </div>
                        </li>
                        <li>
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="d-block t-heading-font heading-clr sm-text"><?php echo app('translator')->get('Available for This Month'); ?></span>
                                <h5 class="sm-text m-0">
                                    <span class="this_month_limit">0</span>
                                    <span class="sending-currency"></span>
                                </h5>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        let agentStatus = `<?php echo e(gs('agent_module')); ?>`;
        let agent = `<?php echo app('translator')->get('Agent'); ?>`;
        let agentFixedCharge = `<?php echo e(gs('agent_charges')->fixed_charge ?? 0); ?>`;
        let agentPercentCharge = `<?php echo e(gs('agent_charges')->percent_charge ?? 0); ?>`;

        let sendLimit = `<?php echo e(gs('user_send_money_limit')); ?>`;
        let sendingAmount = `<?php echo e($sendingAmount); ?>`;
        let recipientAmount = `<?php echo e($recipientAmount); ?>`;
        let deliveryMethodId = `<?php echo e($deliveryMethodId); ?>`;
        let recipientCountryId = `<?php echo e($recipientCountryId); ?>`;
        let sendingCountryId = `<?php echo e($sendingCountryId); ?>`;

        if (deliveryMethodId) {
            deliveryMethodId *= 1;
        }

        let defaultSelectOption = `<?php echo app('translator')->get('Select One'); ?>`;
        let serviceStatus = true;
        let serviceURL = "<?php echo e(route('services')); ?>";
        let serviceLabel = `<?php echo app('translator')->get('Service'); ?>`;
        let isAgent = false;
    </script>

    <script src="<?php echo e(asset('assets/global/js/sendMoney.js')); ?>"></script>

    <script>
        (function($) {
            "use strict";

            $(document).on('change', '.countryServices', function() {
                let serviceId = $(this).val();
                if (serviceId) {
                    let data = {
                        service_id: serviceId
                    }

                    $.get("<?php echo e(route('service.form')); ?>", data,
                        function(data, textStatus, jqXHR) {
                            if (data.success && data.html.length) {
                                $('.formData').html(data.html);
                                $('.formData').find('label').addClass(
                                    'text--accent sm-text d-block fw-md mb-2');
                                $('.formData').removeClass('d-none');
                            } else {
                                $('.formData').html('');
                                $('.formData').addClass('d-none');
                            }
                        }
                    );
                } else {
                    $('.formData').empty();
                }
            });

            $('.walletPayment').on('click', function() {
                checkBalance();
            });

            let availableForToday = 0;
            let availableForThisMonth = 0;
            let limitPerSendMoney = 0;
            let dailyLimit = 0;
            let monthlyLimit = 0;

            $('.country-picker').on('change', function() {
                let general = <?php echo json_encode(gs(), 15, 512) ?>;
                let user = <?php echo json_encode($user, 15, 512) ?>;
                let todaySendMoneyInBaseCur = <?php echo json_encode($todaySendMoney, 15, 512) ?>;
                let thisMonthSendMoneyInBase = <?php echo json_encode($thisMonthSendMoney, 15, 512) ?>;
                let sender = $('[name=sending_country]');
                let baseToSenderCurrency = parseFloat(sender.find(':selected').data('rate'));

                if (user.daily_send_money_limit) {
                    dailyLimit = parseFloat(user.daily_send_money_limit * baseToSenderCurrency).toFixed(2);
                } else {
                    dailyLimit = parseFloat(general.user_daily_send_money_limit * baseToSenderCurrency).toFixed(
                        2);
                }

                if (user.monthly_send_money_limit) {
                    monthlyLimit = parseFloat(user.monthly_send_money_limit * baseToSenderCurrency).toFixed(2);
                } else {
                    monthlyLimit = parseFloat(general.user_monthly_send_money_limit * baseToSenderCurrency)
                        .toFixed(2);
                }

                if (user.per_send_money_limit) {
                    limitPerSendMoney = parseFloat(user.per_send_money_limit * baseToSenderCurrency).toFixed(2);
                } else {
                    limitPerSendMoney = parseFloat(general.user_send_money_limit * baseToSenderCurrency)
                        .toFixed(2);
                }

                availableForToday = parseFloat(dailyLimit - todaySendMoneyInBaseCur * baseToSenderCurrency)
                    .toFixed(2);
                availableForToday = parseFloat(availableForToday > 0 ? availableForToday : 0).toFixed(2);
                availableForThisMonth = parseFloat(monthlyLimit - thisMonthSendMoneyInBase *
                    baseToSenderCurrency).toFixed(2);
                availableForThisMonth = parseFloat(availableForThisMonth > 0 ? availableForThisMonth : 0)
                    .toFixed(2);

                if (parseFloat(availableForToday) > parseFloat(availableForThisMonth)) {
                    availableForToday = availableForThisMonth;
                }

                $('.send_money_limit').text(limitPerSendMoney);
                $('.daily_send_money_limit').text(dailyLimit);
                $('.monthly_send_money_limit').text(monthlyLimit);
                $('.today_limit').text(availableForToday);
                $('.this_month_limit').text(availableForThisMonth);
            }).change();

            $(document).on('input', '.sending-amount, .recipient-amount', function() {
                let sendingAmount = parseFloat($('[name=sending_amount]').val());
                if (sendingAmount > limitPerSendMoney || sendingAmount > availableForToday || sendingAmount >
                    availableForThisMonth) {
                    $('.limitMessage').removeClass('d-none')
                    $('.formSubmitButton').attr('disabled', true);
                } else {
                    $('.limitMessage').addClass('d-none')
                    $('.formSubmitButton').attr('disabled', false);
                }

                if ($('[name=payment_type]:checked').val() == 1) {
                    checkBalance();
                }
            });

            function checkBalance() {
                var balance = $('.walletPayment').data('balance');
                var finalAmount = parseInt($('.base-amount-text').text());
                if (finalAmount > balance) {
                    $('.insufficientBalanceError').removeClass('d-none').fadeIn();
                    $('.formSubmitButton').attr('disabled', true);
                } else {
                    $('.insufficientBalanceError').fadeOut().addClass('d-none');
                    if ($('.limitMessage').hasClass('d-none')) {
                        $('.formSubmitButton').attr('disabled', false);
                    }
                }
            }

            $('.directPayment').on('click', function() {
                $('.insufficientBalanceError').fadeOut().addClass('d-none');
                if ($('.limitMessage').hasClass('d-none')) {
                    $('.formSubmitButton').attr('disabled', false);
                }
            });

            $('.formSubmitButton').on('click', function() {
                var paymentType = $('[name=payment_type]:checked').val();
                if (!paymentType) {
                    notify('error', 'Please select a payment type')
                }
            });

            $('.showLimit').on('click', function() {
                $('#limitModal').modal('show');
            });

            <?php if(old('payment_type') == 1): ?>
                $('.walletPayment').click();
            <?php endif; ?>

            <?php if(old('payment_type') == 2): ?>
                $('.directPayment').click();
            <?php endif; ?>

            $('.existing-recipient').on('change', function() {
                let recipient = $(this).find(':selected').data('recipient')
                if (recipient != undefined) {
                    $('#saveRecipientContainer').addClass('d-none');
                    $('.recipient_name').val(recipient.name);
                    $('#recipient_mobile').val(recipient.mobile);
                    $('#recipient_email').val(recipient.email);
                    $('#recipient_address').val(recipient.address);
                    notify('success', 'Previous recipient data found.')
                } else {
                    $('#saveRecipientContainer').removeClass('d-none');
                    $('.recipient_name').val('');
                    $('#recipient_mobile').val('');
                    $('#recipient_email').val('');
                    $('#recipient_address').val('');
                }
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .exchange-form {
            box-shadow: none;
        }

        .select2-container--default .select2-results__option[aria-disabled=true] {
            display: none;
        }

        .reverseCountryBtn i {
            transform: rotate(90deg);
            font-size: 20px;
        }

        .conversion__rate {
            display: flex;
            justify-content: center;
            font-size: 27px;
            font-weight: 500;
        }

        .exchange-form__body {
            border: unset !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/user/send_money/form.blade.php ENDPATH**/ ?>