<?php $__env->startSection('content'); ?>
<section class="dashboard-section body-collapse">
    <div class="overlay pt-120">
        <div class="container-fruid">
            <div class="d-flex flex-wrap flex-row-reverse justify-content-between align-items-center mb-lg-3">
                <div class="text-end">
                    <a href="<?php echo e(route('ticket.open')); ?>" class="btn btn-sm btn--base mb-2"> <i class="la la-plus"></i>
                        <?php echo app('translator')->get('New Ticket'); ?></a>
                </div>
                <div class="custom--table__header">
                    <h5 class="text-lg-start m-0 text-center"><?php echo app('translator')->get('Support Ticket'); ?></h5>
                </div>
            </div>
            <div class="table-responsive--md">
                <table class="table custom--table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Subject'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Priority'); ?></th>
                            <th><?php echo app('translator')->get('Last Reply'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>[<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($support->ticket); ?>] <?php echo e(__($support->subject)); ?></td>
                                <td><?php echo $support->statusBadge; ?></td>
                                <td>
                                    <?php if($support->priority == Status::PRIORITY_LOW): ?>
                                        <span class="badge badge--dark"><?php echo app('translator')->get('Low'); ?></span>
                                    <?php elseif($support->priority == Status::PRIORITY_MEDIUM): ?>
                                        <span class="badge badge--primary"><?php echo app('translator')->get('Medium'); ?></span>
                                    <?php elseif($support->priority == Status::PRIORITY_HIGH): ?>
                                        <span class="badge badge--warning"><?php echo app('translator')->get('High'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(diffForHumans($support->last_reply)); ?> </td>
                                <td>
                                    <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>" class="btn btn--base btn--sm">
                                        <i class="las la-desktop"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center text-muted"><?php echo e(__($emptyMessage)); ?> </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($supports->hasPages()): ?>
                <div class="mt-4 paginate">
                    <?php echo e(paginateLinks($supports)); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .paginate p {
            margin: 0px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/user/support/index.blade.php ENDPATH**/ ?>