@php
$breadcrumbContent = getContent('breadcrumb.content', true);
@endphp

@extends($activeTemplate . 'layouts.frontend')
@section('content')
 <section class="blog-section">
    <div class="overlay pt-120 pb-120">
        <div class="container wow fadeInUp">
            <div class="row">
                <div class="col-xl-12">
                    <div class="top-area d-flex justify-content-between">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn active" id="all-post-tab" data-bs-toggle="tab" data-bs-target="#all-post" type="button"
                                    role="tab" aria-controls="all-post" aria-selected="true">All</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn" id="paylio-tab" data-bs-toggle="tab" data-bs-target="#paylio" type="button"
                                    role="tab" aria-controls="paylio" aria-selected="false">Paylio</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn" id="business-tab" data-bs-toggle="tab" data-bs-target="#business" type="button"
                                    role="tab" aria-controls="business" aria-selected="false">Business</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn" id="academy-tab" data-bs-toggle="tab" data-bs-target="#academy" type="button"
                                    role="tab" aria-controls="academy" aria-selected="false">Academy</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn" id="how-to-tab" data-bs-toggle="tab" data-bs-target="#how-to" type="button"
                                    role="tab" aria-controls="how-to" aria-selected="false">How to</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn" id="people-tab" data-bs-toggle="tab" data-bs-target="#people" type="button"
                                    role="tab" aria-controls="people" aria-selected="false">People</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="cmn-btn" id="news-tab" data-bs-toggle="tab" data-bs-target="#news" type="button"
                                    role="tab" aria-controls="news" aria-selected="false">News</button>
                            </li>
                        </ul>
                        <form action="#">
                            <div class="form-group mb-40 d-flex align-items-center">
                                <img src="assets/images/icon/search-icon-2.png" alt="icon">
                                <input type="text" placeholder="Search">
                            </div>
                        </form>
                    </div>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="all-post" role="tabpanel" aria-labelledby="all-post-tab">
                            <div class="row">
                                @foreach ($blogs as $blog)
                                <div class="col-lg-4 col-sm-6">
                                    <div class="single-post">
                                        <div class="thumbnail">
                                            <img src="{{ frontendImage('blog', 'thumb_' . @$blog->data_values->image) }}"
                                    alt="blog image" class="" style="height:140px; object-fit:cover; width:100%; border-radius:6px;">
                                        </div>
                                        <div class="blog-text">
                                            <p class="date">{{ $blog->created_at->diffForHumans() }}</p>
                                            <a href="{{ route('blog.details', $blog->slug) }}"><h5>
                                                @php
                                      echo strLimit(strip_tags($blog->data_values->title), 45)
                                      @endphp</h5></a>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @if ($blogs->hasPages())
            <div class="d-flex justify-content-center mt-5">
                {{ paginateLinks($blogs) }}
            </div>
        @endif
    </div>
</section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
