@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @include($activeTemplate . 'sections.banner')
    
@php
    $testimonialContent = getContent('testimonial.content', true);
    $testimonialElements = getContent('testimonial.element', false, null, true);
@endphp
    
<section class="global-payment">
    <div class="overlay pt-120 pb-120">
        <div class="container wow fadeInUp">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="section-header text-center">
                        <h5 class="sub-title">Send money Swiftly</h5>
                        <h2 class="title">Your Trusted Pathway to Global Transfers</h2>
                        <p>Experience faster, smarter, and more secure international payments with M’Cube Global—built for modern customers worldwide.</p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xxl-6 col-xl-5 order-xl-0 order-1">
                    <div class="image-area d-rtl left-side">
                        <img src="assets/images/global-payment-img.png" alt="images" class="max-un">
                    </div>
                </div>
                <div class="col-xxl-6 col-xl-7">
                    <div class="row cus-mar">
                        <div class="col-sm-6 col-6">
                            <div class="single-item">
                                <img src="assets/images/global-payment-icon-1.png" alt="icon">
                                <h5>Reliable Protection</h5>
                                <p>Your money moves across borders backed by strict regulation, secure infrastructure, and continuous monitoring.</p>
                            </div>
                        </div>
                        <div class="col-sm-6 col-6">
                            <div class="single-item">
                                <img src="assets/images/global-payment-icon-2.png" alt="icon">
                                <h5>Built for Every Purpose</h5>
                                <p>Whether you’re supporting family or running a business, our platform delivers seamless transfers tailored to your needs.</p>
                            </div>
                        </div>
                        <div class="col-sm-6 col-6">
                            <div class="single-item">
                                <img src="assets/images/global-payment-icon-3.png" alt="icon">
                                <h5>No Hidden Surprises</h5>
                                <p>We keep things simple—clear pricing, honest exchange rates, and full visibility on every transaction you send.</p>
                            </div>
                        </div>
                        <div class="col-sm-6 col-6">
                            <div class="single-item">
                                <img src="assets/images/global-payment-icon-4.png" alt="icon">
                                <h5>Global Reach</h5>
                                <p>Send money to multiple destinations through our extensive network of banks, wallets, and cash pickup partners worldwide.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="our-solutions">
    <div class="overlay pt-120 pb-120">
        <div class="container wow fadeInUp">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="section-header dark-sec text-center">
                        <h5 class="sub-title">Fast. Secure. Reliable.</h5>
                        <h2 class="title">Smart Solutions for Every Transfer</h2>
                        <p>M’Cube Global empowers individuals and businesses with simple, secure, and cost-effective tools for sending and receiving money across borders.</p>
                    </div>
                </div>
            </div>
            <div class="row cus-mar">
                <div class="col-xl-3 col-6">
                    <div class="single-item">
                        <img src="assets/images/our-solutions-icon-1.png" alt="icon">
                        <h5>International Payments</h5>
                        <p>Send money worldwide with FCA-regulated protection, competitive rates, and real-time delivery notifications.</p>
                    </div>
                </div>

                <div class="col-xl-3 col-6">
                    <div class="single-item">
                        <img src="assets/images/our-solutions-icon-2.png" alt="icon">
                        <h5>Receive Money</h5>
                        <p>Get paid from abroad through bank accounts or mobile money—fast, secure, and supported across major global corridors.</p>
                    </div>
                </div>

                <div class="col-xl-3 col-6">
                    <div class="single-item">
                        <img src="assets/images/our-solutions-icon-3.png" alt="icon">
                        <h5>Business Transfers</h5>
                        <p>Power your business with reliable cross-border payments designed for vendors, suppliers, teams, and international partners.</p>
                    </div>
                </div>

                <div class="col-xl-3 col-6">
                    <div class="single-item">
                        <img src="assets/images/our-solutions-icon-4.png" alt="icon">
                        <h5>Personal Remittance</h5>
                        <p>Support loved ones abroad with affordable transfers that arrive quickly and safely—no hidden charges, ever.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="how-it-works">
    <div class="overlay pb-120">
        <div class="container wow fadeInUp">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-header text-center">
                        <h5 class="sub-title">How it works?</h5>
                        <h2 class="title">Send Money in 3 Simple Steps</h2>
                        <p>M’Cube Global is designed for speed and convenience—set up your transfer in minutes and track it instantly.</p>
                    </div>
                </div>
            </div>
            <div class="row cus-mar">

                <div class="col-xl-3 col-sm-6 col-6">
                    <div class="single-item first text-center">
                        <img src="assets/images/how-works-icon-1.png" alt="icon">
                        <h5>Create an Account</h5>
                        <p>Sign up for free and complete a quick verification process to secure your profile and activate transfers.</p>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6 col-6">
                    <div class="single-item second text-center">
                        <img src="assets/images/how-works-icon-2.png" alt="icon">
                        <h5>Add Recipient</h5>
                        <p>Enter your recipient’s bank or mobile money details and select the country you want to send funds to.</p>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6 col-6">
                    <div class="single-item first text-center">
                        <img src="assets/images/how-works-icon-3.png" alt="icon">
                        <h5>Send Your Money</h5>
                        <p>Pay securely via bank transfer or card and let M’Cube handle the rest with instant processing.</p>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6 col-6">
                    <div class="single-item text-center">
                        <img src="assets/images/how-works-icon-4.png" alt="icon">
                        <h5>Money Delivered</h5>
                        <p>Track your transfer in real time and get notified the moment your recipient receives the funds.</p>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<section class="app-download">
    <div class="overlay pb-120">
        <div class="container wow fadeInUp">
            <div class="row justify-content-between align-items-center">
                <div class="col-lg-6 order-lg-0 order-1">
                    <div class="image-area d-rtl left-side">
                        <img src="assets/images/app-download-img.png" alt="images" class="max-un">
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="section-area">
                        <h5 class="sub-title">App Download</h5>
                        <h2 class="title">Your Money. Your Way. Anytime.</h2>
                        <p>Take full control of your international transfers with the M’Cube Global app. Send money, track payments, and access secure financial tools—right from your phone.</p>
                    </div>
                    <ul class="features">
                        <li>
                            <img src="assets/images/check.png" alt="icon">
                            Secure 2fa login for instant, protected access.
                        </li>
                        <li>
                            <img src="assets/images/check.png" alt="icon">
                            Send money worldwide in just a few quick taps.
                        </li>
                        <li>
                            <img src="assets/images/check.png" alt="icon">
                            Monitor your transfers and view full transaction history.
                        </li>
                        <li>
                            <img src="assets/images/check.png" alt="icon">
                            Get real-time alerts on payments and delivery updates.
                        </li>
                    </ul>
                    <div class="brand-area mt-40">
                        <a href="javascript:void(0)">
                            <img src="assets/images/GooglePlay-btn.png" alt="icon">
                        </a>
                        <a href="javascript:void(0)">
                            <img src="assets/images/apple-btn.png" alt="icon">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="testimonials">
    <div class="overlay pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="section-header text-center">
                        <h5 class="sub-title">Testimonials</h5>
                        <h2 class="title">{{ __(@$testimonialContent->data_values->heading) }}</h2>
                        <p>{{ __(@$testimonialContent->data_values->description) }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid wow fadeInUp">
            <div class="testimonials-carousel">
                @foreach (@$testimonialElements ?? [] as $testimonialElement)
                <div class="single-slide">
                    <div class="single-content">
                        <div class="start-area">
                            @if (is_numeric($testimonialElement->data_values->star_count))
                                @for ($i = 0; $i < $testimonialElement->data_values->star_count; $i++)
                                    <a href="javascript:void(0)"><i class="fas fa-star"></i></a>
                                @endfor
                            @else
                                <a href="javascript:void(0)"><i class="fas fa-star"></i></a>
                            @endif
                        </div>
                        <h5 class="title-area">Great Fast Reliable Service</h5>
                        <p class="xlr">"{{ __($testimonialElement->data_values->description) }}"</p>
                        <div class="profile-area d-flex align-items-center">
                            <div class="icon-area">
                                <img src="assets/images/testimonials-img-1.png" alt="icon">
                            </div>
                            <div class="text-area">
                                <h5>{{ __($testimonialElement->data_values->name) }}</h5>
                                <p>{{ __($testimonialElement->data_values->designation) }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>

@include($activeTemplate . 'sections.' . 'blog')

    <!--@if (@$sections->secs != null)-->
    <!--    @foreach (json_decode($sections->secs) as $sec)-->
    <!--        @include($activeTemplate . 'sections.' . $sec)-->
    <!--    @endforeach-->
    <!--@endif-->
@endsection
