@php
    $class = request()->routeIs('home') ? 'header--primary' : 'header--secondary';
@endphp

<header class="header-section">
    <div class="overlay">
        <div class="container">
            <div class="row d-flex header-area">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <!--@if ($class == 'header--primary')-->
            <!--    <a class="logo logo-dark" href="{{ route('home') }}">-->
            <!--        <img alt="{{ gs('site_name') }}" class="img-fluid logo__is" src="{{ siteLogo('dark') }}" />-->
            <!--    </a>-->
            <!--@endif-->
                    <a class="navbar-brand" href="{{ route('home') }}">
                        <img alt="{{ gs('site_name') }}" class="logo" src="{{ siteLogo() }}" />
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" id="toggle-button"
                        data-bs-target="#navbar-content" aria-expanded="false">
                        <i class="fas fa-bars"></i>
                    </button>
                    <!--<button aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"-->
                    <!--    class="navbar-toggler" data-bs-target="#navbarSupportedContent" data-bs-toggle="collapse"-->
                    <!--    type="button">-->
                    <!--    <span class="menu-toggle"></span>-->
                    <!--</button>-->
                    <div class="navbar-collapse justify-content-end collapse" id="navbar-content">
                        <ul class="navbar-nav mr-auto mb-2 mb-lg-0">
                            <li class="nav-item" style="font-weight: 600;">
                                <a style="font-weight: 600;" class="" href="{{ route('home') }}">@lang('Home')</a>
                            </li>
                            @foreach ($pages as $k => $data)
                                <li class="nav-item" style="font-weight: 600;">
                                    <a style="font-weight: 600; class="" href="{{ route('pages', $data->slug) }}">
                                        {{ __($data->name) }}
                                    </a>
                                </li>
                            @endforeach
                            <li class="nav-item" style="font-weight: 600;">
                                <a style="font-weight: 600;" class="" href="{{ route('blog') }}">@lang('Blog')</a>
                            </li>
                            <li class="nav-item" style="font-weight: 600;">
                                <a style="font-weight: 600;" class="" href="{{ route('contact') }}">@lang('Contact')</a>
                            </li>
                        </ul>
                        <div class="right-area header-action d-flex align-items-center max-un">
                            @guest
                                <a href="{{ route('user.login') }}" class="login">Login</a>
                                <a href="{{ route('user.register') }}" class="cmn-btn">Sign Up
                                    <i class="la la-long-arrow-right"></i>
                                </a>
                            @endguest
                            @auth
                                <a href="{{ route('user.logout') }}" class="login">Logout</a>
                                <a href="{{ route('user.home') }}" class="cmn-btn">Dashboard
                                    <i class="la la-long-arrow-right"></i>
                                </a>
                            @endauth
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    </header>
