<?php $__env->startSection('content'); ?>
    <div class="section section--xl">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-10 col-lg-8 col-xl-6">
                    <div class="card custom--card">
                        <div class="card-body">
                            <div class="alert alert-warning" role="alert">
                                <?php echo app('translator')->get('To get access to your dashboard, you need to complete your profile by submitting the below form with proper information.'); ?>
                            </div>
                            <form method="POST" class="disableSubmission viser-form" action="<?php echo e(route('user.data.submit')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="form-group col-12">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Username'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control checkUser" name="username"
                                            value="<?php echo e(old('username')); ?>" required />
                                        <small class="text--danger usernameExist"></small>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Country'); ?>
                                        </label>
                                        <select name="country" class="form-control form--control select2-basic" required>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option data-mobile_code="<?php echo e($country->dial_code); ?>"
                                                    value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>">
                                                    <?php echo e(__($country->country)); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Mobile'); ?>
                                        </label>
                                        <div class="input-group ">
                                            <span class="input-group-text mobile-code"></span>
                                            <input type="hidden" name="mobile_code">
                                            <input type="hidden" name="country_code">
                                            <input type="number" name="mobile" value="<?php echo e(old('mobile')); ?>"
                                                class="form-control form--control checkUser" required>
                                        </div>
                                        <small class="text--danger mobileExist"></small>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Address'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="address"
                                            value="<?php echo e(old('address')); ?>" required>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('State'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="state"
                                            value="<?php echo e(old('state')); ?>" required>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('Zip'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="zip"
                                            value="<?php echo e(old('zip')); ?>" required>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="form-label sm-text t-heading-font heading-clr fw-md">
                                            <?php echo app('translator')->get('City'); ?>
                                        </label>
                                        <input type="text" class="form-control form--control" name="city"
                                            value="<?php echo e(old('city')); ?>" required>
                                    </div>
                                    <?php
                                        $user = auth()->user();
                                    ?>
                                    <?php if($user->type == Status::BUSINESS_USER): ?>
                                        <div class="col-12">
                                            <?php if (isset($component)) { $__componentOriginal3bd95de28203859144f617d3fb6afebc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3bd95de28203859144f617d3fb6afebc = $attributes; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'act','identifierValue' => 'business-account.data'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ViserForm::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $attributes = $__attributesOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__attributesOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $component = $__componentOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__componentOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn--base w-100 btn--xl">
                                            <?php echo app('translator')->get('Submit'); ?>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            <?php if($mobileCode): ?>
                $(`option[data-code=<?php echo e($mobileCode); ?>]`).attr('selected', '');
            <?php endif; ?>

            $('select[name=country]').on('change', function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
                var value = $('[name=mobile]').val();
                var name = 'mobile';
                checkUser(value, name);
            });

            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));

            $('.checkUser').on('focusout', function(e) {
                var value = $(this).val();
                var name = $(this).attr('name')
                checkUser(value, name);
            });

            function checkUser(value, name) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';

                if (name == 'mobile') {
                    var mobile = `${value}`;
                    var data = {
                        mobile: mobile,
                        mobile_code: $('.mobile-code').text().substr(1),
                        _token: token
                    }
                }
                if (name == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.field} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            }
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/user/user_data.blade.php ENDPATH**/ ?>