<?php
    $contact = getContent('contact.content', true);
    $socialIcons = getContent('social_icon.element', false, null, true);
?>
<?php $__env->startSection('content'); ?>
    <div class="section">
        <div class="container">
            <div class="row g-4 justify-content-between">
                <div class="col-lg-6 col-xl-5">
                    <div class="bg--light">
                        <form class="verify-gcaptcha row g-3 g-sm-4 login__form" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="col-12">
                                <h4 class="mt-0"><?php echo e(__(@$contact->data_values->title)); ?></h4>
                                <p class="mb-0">
                                    <?php echo e(__(@$contact->data_values->description)); ?>

                                </p>
                            </div>
                            <div class="col-12">
                                <label class="text--accent sm-text d-block mb-2 fw-md"><?php echo app('translator')->get('Name'); ?></label>
                                <input class="form-control form--control" name="name"
                                    value="<?php echo e(old('name', @$user->fullname)); ?>"
                                    <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?>>
                            </div>
                            <div class="col-12">
                                <label class="text--accent sm-text d-block mb-2 fw-md"><?php echo app('translator')->get('Email'); ?></label>
                                <input class="form-control form--control" name="email"
                                    value="<?php echo e(old('email', @$user->email)); ?>"
                                    <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?>>
                            </div>
                            <div class="col-12">
                                <label class="text--accent sm-text d-block mb-2 fw-md"><?php echo app('translator')->get('Subject'); ?></label>
                                <input class="form-control form--control" name="subject" type="text"
                                    value="<?php echo e(old('subject')); ?>" required>
                            </div>
                            <div class="col-12">
                                <label class="text--accent sm-text d-block mb-2 fw-md"><?php echo app('translator')->get('Message'); ?></label>
                                <textarea class="form-control form--control-textarea" name="message" rows="3" required><?php echo e(old('message')); ?></textarea>
                            </div>
                            <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve(['class' => 'd-block sm-text'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                            <div class="col-12">
                                <button class="btn btn--xl btn--base"> <?php echo app('translator')->get('Send Message'); ?> </button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-5">
                    <div class="d-flex flex-column gap-5">
                        <img class="img-fluid d-none d-lg-block"
                            src="<?php echo e(frontendImage('contact', @$contact->data_values->image, '525x395')); ?>"
                            alt="contact image">
                        <ul class="list list--column">
                            <li class="list--column__item">
                                <div class="header-top__info">
                                    <span class="header-top__icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </span>
                                    <span class="header-top__text t-short-para">
                                        <?php echo e(__(@$contact->data_values->address)); ?>

                                    </span>
                                </div>
                            </li>
                            <li class="list--column__item">
                                <div class="header-top__info">
                                    <span class="header-top__icon">
                                        <i class="fas fa-phone-alt"></i>
                                    </span>
                                    <a href="Tel:<?php echo e(@$contact->data_values->mobile); ?>">
                                        <span class="header-top__text t-short-para">
                                            <?php echo e(__(@$contact->data_values->mobile)); ?>

                                        </span>
                                    </a>
                                </div>
                            </li>
                            <li class="list--column__item">
                                <div class="header-top__info">
                                    <span class="header-top__icon">
                                        <i class="far fa-envelope"></i>
                                    </span>
                                    <a href="Mailto:<?php echo e(@$contact->data_values->email); ?>">
                                        <span class="header-top__text t-short-para">
                                            <?php echo e(__(@$contact->data_values->email)); ?>

                                        </span>
                                    </a>
                                </div>
                            </li>
                            <li class="list--column__item">
                                <ul class="list list--row-sm align-items-center">
                                    <?php $__currentLoopData = $socialIcons ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a class="social-icon" href="<?php echo e($social->data_values->url); ?>" target="_blank">
                                                <?php echo $social->data_values->icon; ?>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <div class="map-section">
        <div class="container-fluid p-0">
            <div class="row g-0">
                <div class="col-12">
                    <iframe class="map"
                        src="https://maps.google.com/maps?q=<?php echo e(@$contact->data_values->latitude); ?>,<?php echo e(@$contact->data_values->longitude); ?>&hl=es&z=14&amp;output=embed"></iframe>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>