<table class="table">
    <thead>
        <tr>
            <th><?php echo app('translator')->get('MTCN'); ?></th>
            <th><?php echo app('translator')->get('Amount'); ?></th>
            <th><?php echo app('translator')->get('Recipient'); ?></th>
            <th><?php echo app('translator')->get('Send'); ?> | <?php echo app('translator')->get('Received'); ?></th>
            <th><?php echo app('translator')->get('Payment'); ?></th>
            <th><?php echo app('translator')->get('Status'); ?></th>
            <?php if($hasBtn): ?>
                <th><?php echo app('translator')->get('Action'); ?></th>
            <?php endif; ?>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td> #<span class="fw-bold"><?php echo e($transfer->mtcn_number); ?></span></td>
                <td>
                    <div>
                        <span class="fw-md">
                            <?php echo e(showAmount($transfer->sending_amount, currencyFormat: false)); ?>

                            <?php echo e(__($transfer->sending_currency)); ?>

                        </span>
                        <i class="la la-arrow-right"></i>
                        <span class="fw-md">
                            <?php echo e(showAmount($transfer->recipient_amount, currencyFormat: false)); ?>

                            <?php echo e(__($transfer->recipient_currency)); ?>

                        </span>
                    </div>
                    <span class="text--danger">
                        <?php echo app('translator')->get('Charge'); ?>: <?php echo e(showAmount($transfer->sending_charge, currencyFormat: false)); ?>

                        <?php echo e(__($transfer->sending_currency)); ?>

                    </span>
                </td>
                <td>
                    <span class="fw-bold text--primary"><?php echo e($transfer->recipient->name); ?></span>
                    <br>
                    <span class="text-muted">
                        <i class="la la-globe"></i>
                        <?php echo e(__(@$transfer->recipientCountry->name)); ?>

                    </span>
                </td>
                <td>
                    <em><?php echo e(showDateTime($transfer->created_at, 'd M, y h:i a')); ?></em>
                    <br />
                    <em><?php echo e($transfer->received_at ? showDateTime($transfer->received_at, 'd M, y h:i a') : 'N/A'); ?></em>
                </td>
                <td>
                    <span><?php echo e(showAmount($transfer->paidAmount())); ?></span>
                    <br>
                    <?php echo $transfer->paymentStatusBadge; ?>
                    <?php if($transfer->payment_status == Status::PAYMENT_REJECT && $transfer->admin_feedback != null): ?>
                        <button class="btn-info rounded badge feedbackBtn"
                            data-admin_feedback="<?php echo e($transfer->admin_feedback); ?>">
                            <i class="fa fa-info"></i>
                        </button>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($transfer->status == Status::SEND_MONEY_REFUNDED && $transfer->admin_feedback != null): ?>
                        <button class="btn-info rounded badge feedbackBtn"
                            data-admin_feedback="<?php echo e($transfer->admin_feedback); ?>">
                            <i class="fa fa-info"></i>
                        </button>
                    <?php endif; ?>
                    <?php echo $transfer->statusBadge;?>
                </td>
                <?php
                    $details = $transfer->detail != null ? json_encode($transfer->detail) : null;
                ?>
                <?php if($hasBtn): ?>
                    <td>
                        <button class="btn btn--base btn-sm detailBtn"
                            data-address="<?php echo e($transfer->recipient->address); ?>"
                            data-country="<?php echo e(@$transfer->recipientCountry->name); ?>"
                            data-id="<?php echo e(encrypt($transfer->id)); ?>" data-info="<?php echo e($details); ?>"
                            data-mobile="<?php echo e($transfer->recipient->mobile); ?>"
                            data-name="<?php echo e($transfer->recipient->name); ?>"
                            data-payment_status="<?php echo e($transfer->payment_status); ?>"
                            data-payment_via="<?php echo e($transfer->deposit ? @$transfer->deposit->gateway->name : __('Refunded Wallet')); ?>"
                            data-recipient_amount="<?php echo e(showAmount($transfer->recipient_amount, currencyFormat: false)); ?> <?php echo e(__($transfer->recipient_currency)); ?>"
                            data-send_money_amount="<?php echo e($transfer->sending_amount); ?>"
                            data-sending_currency="<?php echo e(__($transfer->sending_currency)); ?>"
                            data-send_amount_in_base_currency="<?php echo e(showAmount($transfer->base_currency_amount + $transfer->base_currency_charge, currencyFormat: false)); ?>"
                            data-total_payable_amount="<?php echo e(showAmount($transfer->paidAmount(), currencyFormat: false)); ?>"
                            data-deposit="<?php echo e($transfer->deposit); ?>"
                            data-delivery_charge="<?php echo e(showAmount($transfer->sending_charge, currencyFormat: false)); ?>"
                            data-including_charge="<?php echo e(showAmount($transfer->sending_amount + $transfer->sending_charge, currencyFormat: false)); ?>"
                            data-status="<?php echo e($transfer->status); ?>" data-mtcn_number="<?php echo e($transfer->mtcn_number); ?>"
                            data-trx="<?php echo e($transfer->trx); ?>"
                            data-conversion_rate="<?php echo e(showAmount($transfer->conversion_rate, decimal: 8, exceptZeros: true, currencyFormat: false)); ?>"
                            data-base_currency_rate="<?php echo e(showAmount($transfer->base_currency_rate, decimal: 8, exceptZeros: true, currencyFormat: false)); ?>"
                            data-recipient_currency="<?php echo e($transfer->recipient_currency); ?>"
                            data-delivery_method="<?php echo e($transfer->country_delivery_method_id ? __($transfer->countryDeliveryMethod->deliveryMethod->name) : __('Agent')); ?>"
                            data-sent_at="<?php echo e(showDateTime($transfer->created_at)); ?>">
                            <i class="la la-desktop"></i>
                        </button>
                    </td>
                <?php endif; ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<?php $__env->startPush('style'); ?>
<style>
.table {
    border-collapse: collapse;
    width: 100%;
    border-radius: 10px;
    border: 1px solid #ddd;
}

.table thead th {
    color: rgb(43 107 127 / var(--tw-bg-opacity, 1)) !important;
    background-color: rgb(43 107 127 / var(--tw-bg-opacity, 1)) !important;
}

.table thead th {
    color: #fff !important;
    padding: 12px;
    font-weight: 600;
    border-bottom: 2px solid rgba(255,255,255,0.2);
}

.table tbody tr {
    border-bottom: 1px solid #ddd; /* Row underline */
}

.table tbody td {
    padding: 12px;
    vertical-align: middle;
}

</style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/templates/basic/partials/send_money_table.blade.php ENDPATH**/ ?>