<?php
    $requiredConfig = new \App\Lib\RequiredConfig();
    $configs = $requiredConfig->getConfig();
    $progressPercentage = $requiredConfig->completedConfigPercent();
    $completedConfig = $requiredConfig->completedConfig();
    uksort($configs, function ($a, $b) use ($completedConfig) {
        $aIndex = array_search($a, $completedConfig);
        $bIndex = array_search($b, $completedConfig);
        $aIndex = $aIndex === false ? -1 : $aIndex + 100;
        $bIndex = $bIndex === false ? -1 : $bIndex + 100;

        return $aIndex <=> $bIndex;
    });
?>
<?php if($requiredConfig->completedConfigCount() < $requiredConfig->totalConfigs()): ?>
    <div class="configure-card">
        <div class="configure-card-header">
            <div class="configure-card-top flex-align gap-4">
                <div class="configure-card-left flex-1">
                    <div class="configure-card-slide">
                        <?php $__currentLoopData = $configs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h6 class="configure-card-title flex-align gap-2 mb-2 flex-nowrap"
                                data-config_url="<?php echo e($config['route']); ?>">
                                <span class="configure-status <?php if(in_array($key, $completedConfig)): ?> complete <?php endif; ?>"><i
                                        class="fas fa-check"></i></span>
                                <?php echo e(__($config['title'])); ?>

                            </h6>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="progress" role="progressbar" aria-label="Basic example" aria-valuenow="0"
                        aria-valuemin="0" aria-valuemax="100">
                        <div class="progress-bar" style="width: <?php echo e($progressPercentage); ?>%"></div>
                    </div>
                </div>
                <a href="" class="configure-card-link flex-shrink-0">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?php echo app('translator')->get('Configure'); ?>
                </a>
            </div>
            <div class="configure-card-bottom flex-align mt-2">
                <a href="javascript:void(0)" class="next-btn">
                    <i class="fa-solid fa-arrow-left"></i>
                    <?php echo app('translator')->get('Previous'); ?>
                </a>
                <div class="flex-1 flex-center gap-2">
                    <span class="count">
                        <span class="configure-count"><?php echo e($requiredConfig->completedConfigCount()); ?></span>
                        <?php echo app('translator')->get('of'); ?> <span class="configure-total"><?php echo e($requiredConfig->totalConfigs()); ?></span>
                    </span>
                    <div class="show-btn">
                        <?php echo app('translator')->get('Show'); ?>
                        <span class="icon text-white">
                            <i class="las la-angle-down"></i>
                        </span>
                    </div>
                </div>
                <a href="javascript:void(0)" class="prev-btn">
                    <?php echo app('translator')->get('Next'); ?>
                    <i class="fa-solid fa-arrow-right"></i>
                </a>
            </div>
        </div>
        <div class="configure-card-body">
            <ul class="configure-list">
                <?php $__currentLoopData = $configs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="configure-item flex-between">
                        <div class="configure-item-name flex-align gap-2">
                            <span class="configure-status <?php if(in_array($key, $completedConfig)): ?> complete <?php endif; ?>"><i
                                    class="fas fa-check text-white"></i></span>
                            <?php echo e(__($config['title'])); ?>

                        </div>

                        <a href="<?php echo e($config['route']); ?>"
                            class="configure-item-btn <?php if(in_array($key, $completedConfig)): ?> disabled <?php endif; ?>">
                            <i class="fas fa-angle-right"></i>
                            <?php echo app('translator')->get('Configure Now'); ?>
                        </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/kikieccj/remit.flecible.com/core/resources/views/components/config-process.blade.php ENDPATH**/ ?>